.PHONY: clean distclean

APP            = encrypt
ALT            = decrypt

COMMON_SRC     = src/common/error.c src/common/mem.c src/common/ccrypt.c src/common/list.c src/common/tlv.c src/common/version.c src/common/config.c src/common/cli.c src/common/dir.c src/common/ecc.c src/common/non-gnu.c
CLI_SRC        = ${COMMON_SRC} src/main.c src/crypt.c src/encrypt.c src/decrypt.c src/crypt_io.c
GUI_SRC        = ${CLI_SRC} src/gui-gtk.c
MISC           = src/common/misc.h

CLI_CFLAGS     = ${CFLAGS} -Wall -Wextra -std=gnu99 $(shell pkg-config --cflags libgcrypt) -pipe -O2 -Wrestrict -Wformat=2 -Wno-unused-result
CLI_CPPFLAGS   = ${CPPFLAGS} -D_GNU_SOURCE -D_FILE_OFFSET_BITS=64 -DGCRYPT_NO_DEPRECATED -DUSE_GCRYPT -DGIT_COMMIT=\"$(shell git log | head -n1 | cut -f2 -d' ')\" -DBUILD_OS=\"$(shell grep PRETTY_NAME /etc/os-release | cut -d= -f2)\"
GUI_CFLAGS     = ${CLI_CFLAGS} $(shell pkg-config --cflags gtk+-3.0 gmodule-2.0)
GUI_CPPFLAGS   = ${CLI_CPPFLAGS} -DBUILD_GUI

DEBUG_CFLAGS   = -O0 -ggdb -pg
DEBUG_CPPFLAGS = -D__DEBUG__ -D__DEBUG_GUI__ -DMALLOC_CHECK_=1
DEBUG_ENC      = ${DEBUG_CPPFLAGS} -D__DEBUG_WITH_ENCRYPTION__

CLI_LIBS       = $(shell pkg-config --libs libgcrypt) -lpthread -lcurl -llzma
GUI_LIBS       = ${CLI_LIBS} $(shell pkg-config --libs gtk+-3.0 gmodule-2.0)

all: gui symlink language man

debug: cli-debug symlink

symlink:
	 @ln -fs ${APP} ${ALT}
	-@echo -e "linked ‘${ALT}’ → ‘${APP}’"

cli: symlink
	 @echo "#define ALL_CFLAGS   \"$(strip $(subst \",\',"${CLI_CFLAGS}"))\""    > ${MISC}
	 @echo "#define ALL_CPPFLAGS \"$(strip $(subst \",\',"${CLI_CPPFLAGS}"))\"" >> ${MISC}
	 @${CC} ${CLI_CFLAGS} ${CLI_CPPFLAGS} ${CLI_SRC} ${CLI_LIBS} -o ${APP}
	-@echo -e "built ‘`echo -e ${CLI_SRC} | sed 's/ /’\n      ‘/g'`’ → ‘${APP}’"

cli-debug:
	 @echo "#define ALL_CFLAGS   \"$(strip $(subst \",\',"${CLI_CFLAGS}   ${DEBUG_CFLAGS}"))\""    > ${MISC}
	 @echo "#define ALL_CPPFLAGS \"$(strip $(subst \",\',"${CLI_CPPFLAGS} ${DEBUG_CPPFLAGS}"))\"" >> ${MISC}
	 @${CC} ${CLI_CFLAGS} ${CLI_CPPFLAGS} ${CLI_SRC} ${CLI_LIBS} ${DEBUG_CFLAGS} ${DEBUG_CPPFLAGS} -o ${APP}
	-@echo -e "built ‘`echo -e ${CLI_SRC} | sed 's/ /’\n      ‘/g'`’ → ‘${APP}’"

cli-debug-with-encryption:
	 @echo "#define ALL_CFLAGS   \"$(strip $(subst \",\',"${CLI_CFLAGS} ${DEBUG_CFLAGS}"))\"" > ${MISC}
	 @echo "#define ALL_CPPFLAGS \"$(strip $(subst \",\',"${CLI_CPPFLAGS} ${DEBUG_ENC}"))\"" >> ${MISC}
	 @${CC} ${CLI_CFLAGS} ${CLI_CPPFLAGS} ${CLI_SRC} ${CLI_LIBS} ${DEBUG_CFLAGS} ${DEBUG_ENC}      -o ${APP}
	-@echo -e "built ‘`echo -e ${CLI_SRC} | sed 's/ /’\n      ‘/g'`’ → ‘${APP}’"

gui:
	 @echo "#define ALL_CFLAGS   \"$(strip $(subst \",\',"${GUI_CFLAGS}"))\""    > ${MISC}
	 @echo "#define ALL_CPPFLAGS \"$(strip $(subst \",\',"${GUI_CPPFLAGS}"))\"" >> ${MISC}
	 @${CC} ${GUI_CFLAGS} ${GUI_CPPFLAGS} ${GUI_SRC} ${GUI_LIBS} -o ${APP}
	-@echo -e "built ‘`echo -e ${GUI_SRC} | sed 's/ /’\n      ‘/g'`’ → ‘${APP}’"

gui-debug:
	 @echo "#define ALL_CFLAGS   \"$(strip $(subst \",\',"${GUI_CFLAGS}   ${DEBUG_CFLAGS}"))\""    > ${MISC}
	 @echo "#define ALL_CPPFLAGS \"$(strip $(subst \",\',"${GUI_CPPFLAGS} ${DEBUG_CPPFLAGS}"))\"" >> ${MISC}
	 @${CC} ${GUI_CFLAGS} ${GUI_CPPFLAGS} ${GUI_SRC} ${GUI_LIBS} ${DEBUG_CFLAGS} ${DEBUG_CPPFLAGS} -o ${APP}
	-@echo -e "built ‘`echo -e ${GUI_SRC} | sed 's/ /’\n      ‘/g'`’ → ‘${APP}’"

gui-debug-with-encryption:
	 @echo "#define ALL_CFLAGS   \"$(strip $(subst \",\',"${GUI_CFLAGS} ${DEBUG_CFLAGS}"))\"" > ${MISC}
	 @echo "#define ALL_CPPFLAGS \"$(strip $(subst \",\',"${GUI_CPPFLAGS} ${DEBUG_ENC}"))\"" >> ${MISC}
	 @${CC} ${GUI_CFLAGS} ${GUI_CPPFLAGS} ${GUI_SRC} ${GUI_LIBS} ${DEBUG_CFLAGS} ${DEBUG_ENC}      -o ${APP}
	-@echo -e "built ‘`echo -e ${GUI_SRC} | sed 's/ /’\n      ‘/g'`’ → ‘${APP}’"

language:
	-@echo -e "TODO - string translation"
#	@${MAKE} -C po

man:
	 @gzip -c docs/${APP}.1a > ${APP}.1a.gz
	-@echo -e "compressing ‘docs/${APP}.1a’ → ‘${APP}.1a.gz"

install:
# install the main executable, also link decrypt
	 @install -m 755 -s -D -T ${APP} ${DESTDIR}/usr/bin/${APP}
	-@echo -e "installed ‘${APP}’ → ‘${DESTDIR}/usr/bin/${APP}’"
	 @ln -f ${DESTDIR}/usr/bin/${APP} ${DESTDIR}/usr/bin/${ALT}
	-@echo -e "linked ‘${ALT}’ → ‘${APP}’"
# install the pixmaps
	 @install -m 644 -D -T pixmaps/encrypt.svg ${DESTDIR}/usr/${LOCAL}/share/pixmaps/encrypt.svg
	-@echo -e "installed ‘pixmaps/encrypt.svg’ → ‘${DESTDIR}/usr/${LOCAL}/share/pixmaps/encrypt.svg’"
	 @install -m 644 -D -T pixmaps/encrypt_button.svg ${DESTDIR}/usr/${LOCAL}/share/pixmaps/encrypt_button.svg
	-@echo -e "installed ‘pixmaps/encrypt_button.svg’ → ‘${DESTDIR}/usr/${LOCAL}/share/pixmaps/encrypt_button.svg’"
	 @install -m 644 -D -T pixmaps/encrypt_key.png ${DESTDIR}/usr/${LOCAL}/share/pixmaps/encrypt_key.png
	-@echo -e "installed ‘pixmaps/encrypt_key.png’ → ‘${DESTDIR}/usr/${LOCAL}/share/pixmaps/encrypt_key.png’"
# next encrypt.glade
	 @install -m 644 -D -T etc/encrypt.glade ${DESTDIR}/usr/${LOCAL}/share/encrypt/encrypt.glade
	-@echo -e "installed ‘etc/encrypt.glade’ → ‘${DESTDIR}/usr/${LOCAL}/share/encrypt/encrypt.glade’"
# and an example rc file
	 @install -m 644 -D -T etc/encryptrc ${DESTDIR}/usr/${LOCAL}/share/encrypt/encryptrc
	-@echo -e "installed ‘etc/encryptrc’ → ‘${DESTDIR}/usr/${LOCAL}/share/encrypt/encryptrc’"
# ditto, but this time for the man page
	 @install -m 644 -D -T encrypt.1a.gz ${DESTDIR}/usr/${LOCAL}/share/man/man1/encrypt.1a.gz
	-@echo -e "installed ‘encrypt.1a.gz’ → ‘${DESTDIR}/usr/${LOCAL}/share/man/man1/encrypt.1a.gz’"
# and then the desktop files
	 @install -m 644 -D -T etc/encrypt.desktop ${DESTDIR}/usr/${LOCAL}/share/applications/encrypt.desktop
	-@echo -e "installed ‘etc/encrypt.desktop’ → ‘${DESTDIR}/usr/${LOCAL}/share/applications/encrypt.desktop’"
	 @install -m 644 -D -T etc/thunar-sendto.desktop ${DESTDIR}/usr/${LOCAL}/share/Thunar/sendto/encrypt.desktop
	-@echo -e "installed ‘etc/thunar-sendto.desktop’ → ‘${DESTDIR}/usr/${LOCAL}/share/Thunar/sendto/encrypt.desktop’"
# and the (example) magic pattern (if all else fails, copy to ~/.magic)
# TODO on Fedora concat to /usr/${LOCAL}/share/misc/magic and then recompile
	 @install -m 644 -D -T etc/magic ${DESTDIR}/usr/${LOCAL}/share/encrypt/magic
	-@echo -e "installed ‘etc/magic’ → ‘${DESTDIR}/usr/${LOCAL}/share/encrypt/magic’"
# and finally the auto-complete scripts
	 @install -m 755 -D -T etc/autocomplete.bash ${DESTDIR}/usr/${LOCAL}/share/bash-completion/completions/encrypt
	-@echo -e "installed ‘etc/autocomplete.bash’ → ‘${DESTDIR}/usr/${LOCAL}/share/bash-completion/completions/encrypt’"
	 @install -m 755 -D -T etc/autocomplete.zsh ${DESTDIR}/usr/${LOCAL}/share/zsh/functions/Completion/Unix/_encrypt
	-@echo -e "installed ‘etc/autocomplete.zsh’ → ‘${DESTDIR}/usr/${LOCAL}/share/zsh/functions/Completion/Unix/_encrypt’"

uninstall:
	 @rm -fvr ${DESTDIR}/usr/${LOCAL}/share/encrypt
	 @rm -fv ${DESTDIR}/usr/${LOCAL}/share/bash-completion/completions/encrypt
	 @rm -fv ${DESTDIR}/usr/${LOCAL}/share/zsh/functions/Completion/Unix/_encrypt
	 @rm -fv ${DESTDIR}/usr/${LOCAL}/share/pixmaps/encrypt.svg
	 @rm -fv ${DESTDIR}/usr/${LOCAL}/share/pixmaps/encrypt_button.svg
	 @rm -fv ${DESTDIR}/usr/${LOCAL}/share/pixmaps/encrypt_key.png
	 @rm -fv ${DESTDIR}/usr/${LOCAL}/share/man/man1/encrypt.1a.gz
	 @rm -fv ${DESTDIR}/usr/${LOCAL}/share/applications/encrypt.desktop
	 @rm -fv ${DESTDIR}/usr/${LOCAL}/share/Thunar/sendto/encrypt.desktop
	 @rm -fv ${DESTDIR}/usr/bin/${ALT}
	 @rm -fv ${DESTDIR}/usr/bin/${APP}

clean:
	 @rm -fv ${MISC}
	 @rm -fv ${APP} ${ALT}
	 @rm -fv gmon.out

distclean: clean
	 @rm -fv ${APP}.1a.gz
	 @rm -fvr pkg build
	 @rm -fv ${APP}*.pkg.tar.xz
	 @rm -fv ${APP}*.pkg.tar.zst
	 @rm -fv ${APP}*.tgz
