/*
 * Common code for dealing with pairs of values.
 * Copyright © 2022-2025, albinoloverats ~ Software Development
 * email: webmaster@albinoloverats.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef _COMMON_PAIR_H_
#define _COMMON_PAIR_H_

/*!
 * \file    pair.h
 * \author  albinoloverats ~ Software Development
 * \date    2022-2025
 * \brief   Common pair-o-values code shared between projects
 *
 * Common pairs structures.
 */

#include <inttypes.h>
#include <stdbool.h>

#include "non-gnu.h"

typedef struct
{
	bool b1;
	bool b2;
}
pair_boolean_s;

typedef struct
{
	int64_t i1;
	int64_t i2;
}
pair_integer_s;

typedef struct
{
	//__float128 d1;
	//__float128 d2;
	long double d1;
	long double d2;
}
pair_decimal_s;

typedef struct
{
	char *s1;
	char *s2;
}
pair_string_s;

typedef struct
{
	void *p1;
	void *p2;
}
pair_object_s;

typedef union
{
	pair_boolean_s boolean;
	pair_integer_s integer;
	pair_decimal_s decimal;
	pair_string_s  string;
	pair_object_s  object;
}
pair_u;

#endif /* _COMMON_PAIR_H_ */
